viewer.mode=OVERLAY

function setup()
    print("reorder tabs to see different versions")
    size = 1
    tab1={3,9,27,81}
    parameter.action("next",nxt)    
    colr={color(255,0,0),color(0,255,0),color(0,255,255),color(255,255,0)}
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene = craft.scene() 
    v=scene.camera:add(OrbitViewer,vec3(50,50,50), 30, 0, 1000)
    v.rx=30
    v.ry=30
    entity = scene:entity()
    volume = entity:add(craft.volume, 200, 200, 200)
    scene.voxels.blocks:addAssetPack("Blocks")
    tab = scene.voxels.blocks:new("Table")
    tab.setTexture(ALL, "Blocks:Table")
    
    scene.voxels:fill("Table")    
    scene.voxels.visibleRadius=200
    scene.voxels:resize(vec3(60,1,60))          
    scene.voxels.coordinates = vec3(50,50,50) 
    show()    
end

function nxt()   
    clr=true
    cube(0,0,0,ss)
    val=val+1
    if val>4 then
        val=1
        v.zoom=3
    end
    ss=tab1[val]
    clr=false
    cube(0,0,0,ss)
    v.zoom=v.zoom*2.8
end

function update(dt)
    scene:update(dt)
end

function draw()
    update(DeltaTime)
    scene:draw()  
end

function show()
    v.zoom=10*size*size
    ss=tab1[size]
    val=size
    cube(0,0,0,ss)
end

function cube(x,y,z,size)
    local s=size//3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size~=3 then
                        cube(x1+x,y1+y,z1+z,s)
                    else
                        volume:set((x1+x+50), (y1+y+50), (z1+z+50), 'name', 'solid', 'color', colr[val])
                    end
                end
            end            
        end
    end
end   